const jwt = require("jsonwebtoken");

exports.findToken = (req) => {
  const auth = req.headers["authorization"];
  if (!auth || auth === undefined) {
    return false;
  }
  const [bearer, token] = auth.split(" ");
  if (!token) {
    return false;
  }
  return token;
};
exports.sign = (params) => {
  return jwt.sign(params, process.env.JWT_SECRET);
};
exports.veriffy = (token) => {
  return jwt.verify(token, process.env.JWT_SECRET);
};



// const withAuth = function(req, res, next) {
//   const token = req.cookies.token;
//   if (!token) {
//     res.status(401).send('Unauthorized: No token provided');
//   } else {
//     jwt.verify(token, secret, function(err, decoded) {
//       if (err) {
//         res.status(401).send('Unauthorized: Invalid token');
//       } else {
//         req.email = decoded.email;
//         next();
//       }
//     });
//   }
// }
// module.exports = withAuth;