const express = require('express');
// const multer = require('multer');
const path = require('path');
const router = express.Router();
const authMiddleware = require('../middlewares/auth');
// const authController = require('../controllers/authController');
const usersController = require('../controllers/users');  
// const groupsController = require('../controllers/groups');
const chatsController = require('../controllers/chats');
const draftsController = require('../controllers/draft');
const { uploadVoice, uploadFile,uploadImg } = require('../middlewares/upload');

const upImg = uploadImg.fields([{ name: 'image', maxCount: 1 }]);
const upVoice = uploadVoice.fields([{ name: 'voiceMessage', maxCount: 1 }]);
const upFiles = uploadFile.fields([{ name: 'file', maxCount: 1 }]);


// const storage = multer.diskStorage({
//     destination: (req, file, cb) => {
//       cb(null, './uploads');
//     },
//     filename: (req, file, cb) => {
//       cb(
//         null,
//         new Date().toISOString().replace(/:/g, '-') + '-' + file.originalname
//       );
//     },
//   });
//   const filefilter = (req, file, cb) => {
//     if (
//       file.mimetype === 'image/png' ||
//       file.mimetype === 'image/jpg' ||
//       file.mimetype === 'image/jpeg'
//     ) {
//       cb(null, true);
//     } else {
//       cb(null, false);
//     }
//   };
//   const upload = multer({ storage: storage, filefilter: filefilter });

router.post("/users",authMiddleware, usersController.getUsers);
router.get("/pv",authMiddleware, usersController.pv);
router.get("/messages",authMiddleware, chatsController.messages);
router.get("/draft",authMiddleware, draftsController.getDraft);
// router.get("/sets", usersController.sets);
// router.post("/image",upImg, usersController.image);
// router.post("/settings", usersController.settings);
router.post("/updateUser", upImg ,usersController.updateUser);
router.post("/uploadVoice", upVoice ,chatsController.uploadVoice);
router.post("/uploadImage", upImg ,chatsController.uploadImage);
router.post("/uploadFile", upFiles ,chatsController.uploadFile);
// router.post("/setSettings" ,usersController.setSettings);

module.exports = router; 