const express = require("express");
const Group = require("../configs/db/models/mongoose/groups");

exports.getGroups = async (req, res) => {
    try {
      const groups = await Group.find()
        .populate({
          path: "messages.sender",
          model: "User",
        })
        .populate({
          path: "messages.sender",
          model: "User",
        })
        .sort({ createdAt: -1 })
        .exec();
  
      const groupsWithLastMessages = groups.map((group) => {
        const lastMessage =
          group.messages.length > 0
            ? group.messages[group.messages.length - 1]
            : null;
  
        return {
          _id: group._id,
          name: group.name,
          admin: group.admin,
          members: group.members,
          description: group.description,
          avatar: group.avatar,
          lastMessage,
        };
      });
  
      res.json(groupsWithLastMessages);
    } catch (error) {
      res.status(500).json({ message: error.message });
    }
  };

exports.getGroupById = async (req, res) => {
  res.json(res.group);
};

exports.createGroup = async (req, res) => {
    const { name, admin, members, description, messages } = req.body;
console.log('name, admin, members, description, messages',name, admin, members, description, messages)
    try {
      const newGroup = await Group.create({
        name,
        admin,
        members,
        description,
        messages,
      });
  
      res.status(201).json(newGroup);
    } catch (error) {
      res.status(400).json({ message: error.message });
    }


//   const group = new Group(req.body);
//   try {
//     const newGroup = await group.save();
//     res.status(201).json(newGroup);
//   } catch (error) {
//     res.status(400).json({ message: error.message });
//   }
};

exports.updateGroupById = async (req, res) => {
  if (req.body.name != null) {
    res.group.name = req.body.name;
  }
  if (req.body.description != null) {
    res.group.description = req.body.description;
  }

  try {
    const updatedGroup = await res.group.save();
    res.json(updatedGroup);
  } catch (error) {
    res.status(400).json({ message: error.message });
  }
};

exports.deleteGroupById = async (req, res) => {
  try {
    await res.group.remove();
    res.json({ message: "Group deleted successfully" });
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};
