const express = require("express");
const router = express.Router();
const Channel = require("../models/channels"); // آدرس مدل کانال را به متغیر Channel وارد کنید

// GET - دریافت همه کانال‌ها
router.get("/", async (req, res) => {
  try {
    const channels = await Channel.find();
    res.json(channels);
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
});

// GET - دریافت یک کانال با شناسه مشخص
router.get("/:id", getChannel, (req, res) => {
  res.json(res.channel);
});

// POST - ایجاد یک کانال جدید
router.post("/", async (req, res) => {
  const channel = new Channel(req.body);

  try {
    const newChannel = await channel.save();
    res.status(201).json(newChannel);
  } catch (error) {
    res.status(400).json({ message: error.message });
  }
});

// PUT - به‌روزرسانی یک کانال
router.put("/:id", getChannel, async (req, res) => {
  if (req.body.name != null) {
    res.channel.name = req.body.name;
  }
  if (req.body.description != null) {
    res.channel.description = req.body.description;
  }

  try {
    const updatedChannel = await res.channel.save();
    res.json(updatedChannel);
  } catch (error) {
    res.status(400).json({ message: error.message });
  }
});

// DELETE - حذف یک کانال
router.delete("/:id", getChannel, async (req, res) => {
  try {
    await res.channel.remove();
    res.json({ message: "Channel deleted successfully" });
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
});

// Middleware برای دریافت یک کانال با شناسه مشخص
async function getChannel(req, res, next) {
  let channel;
  try {
    channel = await Channel.findById(req.params.id);
    if (channel == null) {
      return res.status(404).json({ message: "Channel not found" });
    }
  } catch (error) {
    return res.status(500).json({ message: error.message });
  }

  res.channel = channel;
  next();
}

module.exports = router;
