require("dotenv").config();
const cookieSession = require("cookie-session");
// const session = require('express-session');
const express = require("express");
const passportSetup = require("./middlewares/passport");
const passport = require("passport");
const path = require("path");
const { createServer } = require("http");
const { Server } = require("socket.io");

const port = process.env.PORT || 3550;

const app = express();
const httpServer = createServer(app);
// const io = new Server(httpServer, {
//   cors: {
//     // origin: process.env.FRONTEND_ORIGIN,
//     origin: "http://localhost:3000",
//     //     // methods: ["GET", "POST"]
//     // methods: "GET,POST,PUT,DELETE",
//     // credentials: true,
//   },
// });
const io = new Server(httpServer, {
  cors: {
    // origin: "http://localhost:3000",
    origin: ["https://chatgram.behnamkh.ir","http://localhost:3000"],
    methods: ["GET", "POST", "PUT", "PATCH", "DELETE"], // متد‌های مجاز
    credentials: true, // فعال کردن اشتراک سرور
  },
});

app.use(express.static("public"));
// app.use("/uploads", express.static(path.join(__dirname, "uploads")));
app.use(
  cookieSession({ name: "session", keys: ["lama", "anotherKey", "yetAnotherKey"], maxAge: 1000000 })
);   
// app.use(session({
//   secret: process.env.JWT_SECRET, // کلید مخفی برای امنیت جلسه
//   resave: false,
//   saveUninitialized: true, 
// }));   
app.use(passport.initialize());
app.use(passport.session());
 

require("./middlewares")(app); 
require("./routes")(app);
require("./middlewares/socket")(io);
exports.io = io;

httpServer.listen(port, () => {
  // sms.post();
  console.log(`behnam is connected : ${port}`);
});