let activeUsers = [];
const usersController = require("../controllers/users");
const chatsController = require("../controllers/chats");
const draftsController = require("../controllers/draft");
const { getReplyMsgFromChat } = require("../utils/functions");
const path = require("path");
const fs = require("fs");
module.exports = (io) => {
  io.on("connection", (socket) => {
    console.log(`${socket.id} connected`, socket.handshake.query.userId);
    // console.log(`${socket.id} connected`, socket.request);

    // socket.on("active-user",  ( userId ) => {
    //   console.log(`userId`, userId);
    // });
    // console.log(
    //   "typeof",
    //   typeof socket.handshake.query.userId,
    //   socket.handshake.query.userId
    // );
    // ===============
    // let userIds = new Set();
    // userIds.add(socket.handshake.query.userId)

    const userIndex = activeUsers.findIndex(
      (element) => element.userId == socket.handshake.query.userId
    );
    if (userIndex == -1) {
      activeUsers.push({
        socketId: socket.id,
        userId: socket.handshake.query.userId,
      });
    } else {
      activeUsers[userIndex].socketId = socket.id;
    }

    socket.on(`getOnline`, () => {
      socket.emit(`getOnline`, activeUsers);
    });
    console.log("activeUsers", activeUsers);
    // // io.emit("users",{activeUsers,user_id:socket.handshake.query.userId});
    io.emit(`online`, activeUsers);
    socket.emit(`online`, activeUsers);
    // // console.log("activeUsers", activeUsers);
    // usersController.update(
    //   socket.handshake.query.userId,
    //   socket.id,
    //   Date.now(),
    //   true
    // );

    socket.on("info-user", async ({ item, me }) => {
      const getLastOne = await chatsController.getLastOne(me, item._id);
      console.log("getLastOne", getLastOne, item, me);
      io.to(socket.id).emit("info-user", getLastOne);
    });

    socket.on("call-user", async ({ offer, from, to, socketIdsfrom }) => {
      const userIndex = activeUsers.findIndex(
        (element) => element.userId == to
      );
      if (userIndex != -1) {
        io.to(activeUsers[userIndex].socketId).emit("call-made", {
          offer: offer,
          socket: socket.id,
          from: from,
        });
      }
    });
    socket.on("make-answer", async (data) => {
      const userIndex = activeUsers.findIndex(
        (element) => element.userId == data.to
      );
      if (userIndex != -1) {
        io.to(activeUsers[userIndex].socketId).emit("answer-made", {
          socket: socket.id,
          answer: data.answer,
        });
      }
    });

    socket.on("reject-call", (data) => {
      socket.to(data.from).emit("call-rejected", {
        socket: socket.id,
      });
    });
    socket.on("reject-callTo", (data) => {
      const userIndex = activeUsers.findIndex(
        (element) => element.userId == data.to
      );
      if (userIndex != -1) {
        io.to(activeUsers[userIndex].socketId).emit("call-rejectedTo", {
          socket: socket.id,
        });
      }
    });

    socket.on("callUser", (data) => {
      const userIndex = activeUsers.findIndex(
        (element) => element.userId == data.to
      );
      if (userIndex != -1) {
        io.to(activeUsers[userIndex].socketId).emit("callUser", {
          signal: data.signalData,
          to: data.to,
          from: data.from,
          name: data.name,
        });
      }
    });

    socket.on("answerCall", (data) => {
      const userIndex = activeUsers.findIndex(
        (element) => element.userId == data.to
      );
      if (userIndex != -1) {
        io.to(activeUsers[userIndex].socketId).emit(
          "callAccepted",
          data.signal
        );
      }
    });
    socket.on("endCall", (data) => {
      console.log("endCall", data);
      const receiverIndex = activeUsers.findIndex(
        (element) => element.userId == data.receiver
      );
      if (receiverIndex != -1) {
        io.to(activeUsers[receiverIndex].socketId).emit("endCall", data);
      }
      const callerIndex = activeUsers.findIndex(
        (element) => element.userId == data.caller
      );
      if (callerIndex != -1) {
        io.to(activeUsers[callerIndex].socketId).emit("endCall", data);
      }
    });

    socket.on("uploadPercentage", ({progress,type: endpoint,pvId,myId})=>{
      const callerIndex = activeUsers.findIndex(
        (element) => element.userId == myId
      );
      if (callerIndex != -1) {
        io.to(activeUsers[callerIndex].socketId).emit("uploadPercentage", {progress,type: endpoint,pvId,myId});
      }
    });

    socket.on(
      "send-message",
      async ({ msg, sender, receiver, replyId, chatId }) => {
        // console.log('replyId ',replyId )
        // console.log('chatId ',chatId )
        // return;
        console.log("msg", msg, sender, receiver);
        // const user = await usersController.get(receiver);
        const userIndex = activeUsers.findIndex(
          (element) => element.userId == receiver
        );
        console.log("userIndex", userIndex);

        const status = (await chatId)
          ? chatsController.update(msg, chatId)
          : chatsController.save(msg, sender, receiver, replyId);
        if (status) {
          await draftsController.deleteDraft(sender, receiver);
          const messages = await chatsController.get(sender, receiver);
          const oldMessages = await chatsController.getOldMessages(
            sender,
            receiver
          );
          const newMessages = await chatsController.getNewMessages(
            sender,
            receiver
          );
          // io.to(socket.id).emit(`send-message`, {messages,sender,receiver});
          const getLastOne = await chatsController.getLastOne(receiver, sender);
          console.log("getLastOnes", getLastOne);
          // io.to(socket.id).emit(`getOldMessages`, {
          //   oldMessages,
          //   sender,
          //   receiver,
          // });
          io.to(socket.id).emit(`getNewMessages`, {
            newMessages,
            sender,
            receiver,
          });
          if (userIndex > -1) {
            console.log(
              "activeUsers[userIndex].socketId",
              activeUsers[userIndex].socketId
            );
            io.to(activeUsers[userIndex].socketId).emit(
              "info-user",
              getLastOne
            );
            // io.to(user.socket_id).emit(`send-message`, {messages,sender,receiver});

            // io.to(activeUsers[userIndex].socketId).emit(`getOldMessages`, {
            //   oldMessages,
            //   sender,
            //   receiver,
            // });
            io.to(activeUsers[userIndex].socketId).emit(`getNewMessages`, {
              newMessages,
              sender,
              receiver,
            });
            io.to(activeUsers[userIndex].socketId).emit(`notification`);
          }
        }
      }
    );

    // socket.on("getOldMessages", async ({ sender, receiver }) => {
    //   const oldMessages = await chatsController.getOldMessages(
    //     sender,
    //     receiver
    //   );
    //   io.to(socket.id).emit(`getOldMessages`, {
    //     oldMessages,
    //     sender,
    //     receiver,
    //   });
    // });

    // socket.on("getNewMessages", async ({ sender, receiver }) => {
    //   const newMessages = await chatsController.getNewMessages(
    //     sender,
    //     receiver
    //   );
    //   io.to(socket.id).emit(`getNewMessages`, {
    //     newMessages,
    //     sender,
    //     receiver,
    //   });
    // });

    socket.on("uploadVoice", async ({ id,filePath, sender, receiver,reply,chatId }) => {
      // const userReceiver = await usersController.get(receiver);
       await chatsController.updateById({id,reply});
      const messages = await chatsController.get(sender, receiver);

      io.to(socket.id).emit(`send-message`, { messages, sender, receiver });
      const getLastOne = await chatsController.getLastOne(receiver, sender);
      const userIndex = activeUsers.findIndex(
        (element) => element.userId == receiver
      );
      if (userIndex != -1) {
        console.log(
          "filePath, sender, receiver",
          userIndex,
          activeUsers[userIndex].socketId,
          sender,
          receiver
        );
        io.to(activeUsers[userIndex].socketId).emit("info-user", getLastOne);
        io.to(activeUsers[userIndex].socketId).emit(`send-message`, {
          messages,
          sender,
          receiver,
        });
        io.to(activeUsers[userIndex].socketId).emit(`notification`);
      }
    });

    socket.on("deleteMsg", async ({ idMsg, pvId, myId }) => {
      console.log("deleteMsg", idMsg, pvId, myId);
      const messages = await chatsController.delete(idMsg, pvId, myId);
      io.to(socket.id).emit(`deleteMsg`, { idMsg, pvId, myId });
      const userIndex = activeUsers.findIndex(
        (element) => element.userId == pvId
      );
      if (userIndex != -1) {
        io.to(activeUsers[userIndex].socketId).emit(`deleteMsg`, {
          idMsg,
          pvId,
          myId,
        });
      }
    });
    // socket.on("uploadImage", async ({ filePath, sender, receiver }) => {
    //   const userReceiver = await usersController.get(receiver);
    //   const messages = await chatsController.get(sender, receiver);
    //   // io.to(socket.id).emit(`send-message`, { messages, sender, receiver });
    //   const getLastOne = await chatsController.getLastOne(receiver, sender);
    //   io.to(userReceiver.socket_id).emit("info-user", getLastOne);
    //   // console.log('messages',messages)
    //   // io.to(userReceiver.socket_id).emit(`send-message`, {
    //   //   messages,
    //   //   sender,
    //   //   receiver,
    //   // });
    //   // io.to(socket.id).to(userReceiver.socket_id).emit(`getNewMessages`, {
    //   //   filePath,
    //   //   sender,
    //   //   receiver,
    //   // });
    //   io.to(userReceiver.socket_id).emit(`notification`);

    //   const newMessages = await chatsController.getNewMessages(
    //     sender,
    //     receiver
    //   );
    //   io.to(socket.id).to(userReceiver.socket_id).emit(`getNewMessages`, {
    //     newMessages,
    //     sender,
    //     receiver,
    //   });
    //   socket.on("getOldMessages", async ({ sender, receiver }) => {
    //     const oldMessages = await chatsController.getOldMessages(
    //       sender,
    //       receiver
    //     );
    //     io.to(socket.id).to(userReceiver.socket_id).emit(`getOldMessages`, {
    //       oldMessages,
    //       sender,
    //       receiver,
    //     });
    //   });
    // });

    socket.on("seen", async ({ sender, receiver }) => {
      const seen = await chatsController.seen(sender, receiver);
      const getCountNewMessages = await chatsController.getCountNewMessages(
        sender,
        receiver
      );
      console.log("getCountNewMessages", getCountNewMessages);
      const newMessages = await chatsController.getNewMessages(
        sender,
        receiver
      );
      io.to(socket.id).emit(`info-user${receiver}`, getCountNewMessages);
      io.to(socket.id).emit(`getNewMessages`, {
        newMessages,
        sender,
        receiver,
      });
      const userIndex = activeUsers.findIndex(
        (element) => element.userId == sender
      );
      if (userIndex != -1) {
        io.to(activeUsers[userIndex].socketId).emit(`getNewMessages`, {
          newMessages,
          sender,
          receiver,
        });
      }
    });
   socket.on("seenById", async ({ msgId, sender, receiver, msg }) => {
      console.log("seenById", msgId, sender, receiver, msg);
      //      const userSender = await usersController.get(sender);
      //      const userReceiver = await usersController.get(receiver);
      const seen = await chatsController.seenMsg(msgId);
      // const messages = await chatsController.get(sender,receiver)
      // io.to(socket.id).emit(`send-message`, {messages,sender,receiver});
      // io.to(userReceiver.socket_id).emit(`unread-count${sender}`)
      // io.to(userSender.socket_id).emit(`readed-messages${receiver}`,messages)
      //      const oldMessages = await chatsController.getOldMessages(
      //        sender,
      //        receiver
      //      );

      const getCountNewMessages = await chatsController.getCountNewMessages(
        sender,
        receiver
      );
      
      // io.to(socket.id).emit(`send-message`, {messages,sender,receiver});
      //      const getLastOne = await chatsController.getLastOne(receiver, sender);
      io.to(socket.id).emit(`info-user${sender}`, getCountNewMessages);
      console.log('msgIdmsgId',msgId)
      io.emit(`seenById${msgId}`);
      // io.to(socket.id).emit(`send-message`, {messages,sender,receiver});
      //      const getLastOne = await chatsController.getLastOne(receiver, sender);
      io.to(socket.id).emit(`info-user${sender}`, getCountNewMessages);

      // io.to(user.socket_id).emit(`send-message`, {messages,sender,receiver});

      // io.to(userSender.socket_id).emit(`seenById${msgId}`);

      //      io.to(socket.id).to(userSender.socket_id).emit(`getOldMessages`, {oldMessages,sender,receiver});
      //      io.to(socket.id).to(userSender.socket_id).emit(`getNewMessages`, {newMessages,sender,receiver});

      // io.to(userReceiver.socket_id).to(socket.id).emit(`send-message`, {messages,sender,receiver});

    //   const userIndex = activeUsers.findIndex(
    //     (element) => element.userId == sender
    //   );
    //   if (userIndex != -1) {
    //     io.to(activeUsers[userIndex].socketId).emit(`seenById${msgId}`, {
    //       receiver,
    //       sender,
    //     });
    //   }
    });

    // socket.on("draftMsg", async ({ msg, reciver, sender }) => {
    //   await draftsController.draft(msg, sender, reciver);
    //   io.to(socket.id).emit(`draftMsg`, { msg, reciver, sender });
    // });
    socket.on("editMsg", async ({ msg, msgId, receiver, sender }) => {
      await draftsController.draft(msg, sender, receiver, "edit", msgId);
      // console.log('getdraft',msg, msgId, receiver, sender)message, sender, receiver, type="normal" ,chatId=''
      const getdraft = await draftsController.get({ sender, receiver });

      console.log("getdraft", getdraft);
      const chat = await chatsController.getById(msgId);
      if (chat.sender) {
        const user = await usersController.getById(chat.sender);
        console.log("chatchat", chat, user, {
          msgId,
          msg: chat.message,
          username: user.username,
        });
        io.to(socket.id).emit(`editMsg`, {
          draftId: getdraft._id,
          type: getdraft.type,
          draftMsg: getdraft.message,
          msgId,
          msg,
          username: user.username,
        });
      }
    });
    socket.on("replyMsg", async ({ msg, msgId, receiver, sender }) => {
      await draftsController.draft("", sender, receiver, "reply", msgId);
      // console.log('getdraft',msg, msgId, receiver, sender)(msg,sender ,receiver ,"edit",msgId);
      const getdraft = await draftsController.get({ sender, receiver });

      console.log("getdraft", getdraft);
      const chat = await chatsController.getById(msgId);
      if (chat.sender) {
        const user = await usersController.getById(chat.sender);
        console.log("chatchat", chat, user, {
          msgId,
          msg: chat.message,
          username: user.username,
        });
        const msg = getReplyMsgFromChat(chat);
        // console.log('msg',msg)
        // let msg = chat.type == 'voice' ? '🎤 Voice message': chat.message;
        io.to(socket.id).emit(`replyMsg`, {
          draftId: getdraft._id,
          type: getdraft.type,
          draftMsg: getdraft.message,
          msgId,
          msg,
          username: user.username,
        });
      }
    });
    socket.on("getReplyMsg", async ({ sender, receiver }) => {
      // await draftsController.draft('',sender ,receiver ,msgId);
      // console.log('getdraft',msg, msgId, receiver, sender)
      const getdraft = await draftsController.get({ sender, receiver });

      console.log("getdraft", getdraft);
      // const chat = await chatsController.getById(getdraft.);
      if (getdraft && getdraft.type && getdraft.chatId) {
        const chat = await chatsController.getById(getdraft.chatId);
        const user = await usersController.getById(sender);
        console.log("chatchat", chat, user, {
          msgId: chat._id,
          msg: chat.message,
          username: user.username,
        });
        io.to(socket.id).emit(`replyMsg`, {
          draftId: getdraft._id,
          type: getdraft.type,
          draftMsg: getdraft.message,
          msgId: chat._id,
          msg: chat.message,
          username: user.username,
        });
      }
    });
    socket.on("getEditMsg", async ({ sender, receiver }) => {
      const getdraft = await draftsController.get({ sender, receiver });
      if (getdraft && getdraft.type && getdraft.chatId) {
        const chat = await chatsController.getById(getdraft.chatId);
        const user = await usersController.getById(sender);
        io.to(socket.id).emit(`editMsg`, {
          draftId: getdraft._id,
          type: getdraft.type,
          draftMsg: getdraft.message,
          msgId: chat._id,
          msg: chat.message,
          username: user.username,
        });
      }
    });
    socket.on("deleteReplyMsg", async (draftId) => {
      console.log("draftId", draftId);
      await draftsController.update(
        { _id: draftId },
        { chatId: "", type: "", message: "" }
      );
      io.to(socket.id).emit(`deleteReplyMsg`);
    });
    socket.on("deleteEditMsg", async (draftId) => {
      console.log("draftId", draftId);
      await draftsController.update(
        { _id: draftId },
        { chatId: "", type: "", message: "" }
      );
      io.to(socket.id).emit(`deleteEditMsg`);
    });
    socket.on("istyping", async ({ msg, reciver, sender }) => {
      console.log("msg,reciver, sender", msg, reciver, sender);
      draftsController.draft(msg, sender, reciver);
      const userIndex = activeUsers.findIndex(
        (element) => element.userId == reciver
      );
      if (userIndex != -1) {
        io.to(activeUsers[userIndex].socketId).emit(`istyping`, {
          reciver,
          sender,
        });
      }
      // const user = await usersController.get(reciver);
    });
    socket.on("disconnect", () => {
      // console.log(
      //   "socket disconnected...",
      //   socket.id,
      //   socket.handshake.query.userId
      // );
      const userIndex = activeUsers.findIndex(
        (element) => element.userId == socket.handshake.query.userId
      );
      if (userIndex > -1) {
        activeUsers.splice(userIndex, 1);
      }
      console.log("activeUsers dis", activeUsers);
      usersController.update(socket.handshake.query.userId);
      io.emit(`offline`, activeUsers);
      // socket.emit(`offline`, {
      //   activeUsers,
      //   socketId: socket.id,
      //   userId: socket.handshake.query.userId,
      // });
      // socket.broadcast.emit('callended');
    });

    // Start Video Call
    //   socket.on("calluser", async({ userToCall, signalData, from }) => {
    //     const userCall = await usersController.get(userToCall);
    //     io.to(userCall.socket_id).emit("calluser", { signal: signalData, from });
    //   });
    //   socket.on('answercall', async(data) => {
    //     // console.log('signal',data.to)
    //     const userCall = await usersController.get(data.to);
    //     // console.log('signal',userCall.socket_id)
    //     io.to(userCall.socket_id).emit('callaccepted', data.signal);
    // });
    // End Video Call

    // groups
    // socket.on("info-group", async ({ item, me }) => {
    //   // const getLastOne = await chatsController.getLastOne( me,item._id)
    //   // io.to(socket.id).emit('info-group',getLastOne)
    // });

    // socket.on("send-group", async ({ msg,sender, receiver }) => {
    //   // const getLastOne = await chatsController.getLastOne( me,item._id)
    //   // io.to(socket.id).emit('info-group',getLastOne)
    //   io.breadcast.to(receiver).emit('info-group',getLastOne)
    // });
  });
};




// let activeUsers = [];
// const usersController = require("../controllers/users");
// const chatsController = require("../controllers/chats");
// const draftsController = require("../controllers/draft");
// const { getReplyMsgFromChat } = require("../utils/functions");
// module.exports = (io) => {
//   io.on("connection", (socket) => {
//     console.log(`${socket.id} connected`, socket.handshake.query.userId);
//     // console.log(`${socket.id} connected`, socket.request);

//     // socket.on("active-user",  ( userId ) => {
//     //   console.log(`userId`, userId);
//     // });
//     // console.log(
//     //   "typeof",
//     //   typeof socket.handshake.query.userId,
//     //   socket.handshake.query.userId
//     // );
//     // ===============
//     // let userIds = new Set();
//     // userIds.add(socket.handshake.query.userId)

//     const userIndex = activeUsers.findIndex(
//       (element) => element.userId == socket.handshake.query.userId
//     );
//     if (userIndex == -1) {
//       activeUsers.push({
//         socketId: socket.id,
//         userId: socket.handshake.query.userId,
//       });
//     } else {
//       activeUsers[userIndex].socketId = socket.id;
//     }

//     socket.on(`getOnline`, () => {
//       socket.emit(`getOnline`, activeUsers);
//     });
//     console.log("activeUsers", activeUsers);
//     // // io.emit("users",{activeUsers,user_id:socket.handshake.query.userId});
//     io.emit(`online`, activeUsers);
//     socket.emit(`online`, activeUsers);
//     // // console.log("activeUsers", activeUsers);
//     // usersController.update(
//     //   socket.handshake.query.userId,
//     //   socket.id,
//     //   Date.now(),
//     //   true
//     // );

//     socket.on("info-user", async ({ item, me }) => {
//       const getLastOne = await chatsController.getLastOne(me, item._id);
//       console.log("getLastOne", getLastOne, item, me);
//       io.to(socket.id).emit("info-user", getLastOne);
//     });

//     socket.on("call-user", async ({ offer, from, to, socketIdsfrom }) => {
//       const userIndex = activeUsers.findIndex(
//         (element) => element.userId == to
//       );
//       if (userIndex != -1) {
//         io.to(activeUsers[userIndex].socketId).emit("call-made", {
//           offer: offer,
//           socket: socket.id,
//           from: from,
//         });
//       }
//     });
//     socket.on("make-answer", async (data) => {
//       const userIndex = activeUsers.findIndex(
//         (element) => element.userId == data.to
//       );
//       if (userIndex != -1) {
//         io.to(activeUsers[userIndex].socketId).emit("answer-made", {
//           socket: socket.id,
//           answer: data.answer,
//         });
//       }
//     });

//     socket.on("reject-call", (data) => {
//       socket.to(data.from).emit("call-rejected", {
//         socket: socket.id,
//       });
//     });
//     socket.on("reject-callTo", (data) => {
//       const userIndex = activeUsers.findIndex(
//         (element) => element.userId == data.to
//       );
//       if (userIndex != -1) {
//         io.to(activeUsers[userIndex].socketId).emit("call-rejectedTo", {
//           socket: socket.id,
//         });
//       }
     
//     });



//       socket.on("callUser", (data) => {
//       const userIndex = activeUsers.findIndex(
//         (element) => element.userId == data.to
//       );
//       if (userIndex != -1) {
//       io.to(activeUsers[userIndex].socketId).emit("callUser", { signal: data.signalData, from: data.from, name: data.name })
//   }
//     })
  
//     socket.on("answerCall", (data) => {
//       const userIndex = activeUsers.findIndex(
//         (element) => element.userId == data.to
//       );
//       if (userIndex != -1) {
//       io.to(activeUsers[userIndex].socketId).emit("callAccepted", data.signal)
//       }
//     })
//      socket.on("endCall", (data) => {
//           const receiverIndex = activeUsers.findIndex(
//             (element) => element.userId == data.receiver
//           );
//           if (receiverIndex != -1) {
//           io.to(activeUsers[receiverIndex].socketId).emit("endCall", data)
//           }
//           const callerIndex = activeUsers.findIndex(
//             (element) => element.userId == data.caller
//           );
//           if (callerIndex != -1) {
//           io.to(activeUsers[callerIndex].socketId).emit("endCall", data)
//           }
//         })
//  socket.on("uploadPercentage", ({progress,type: endpoint,pvId,myId})=>{
//       const callerIndex = activeUsers.findIndex(
//         (element) => element.userId == myId
//       );
//       if (callerIndex != -1) {
//         io.to(activeUsers[callerIndex].socketId).emit("uploadPercentage", {progress,type: endpoint,pvId,myId});
//       }
//     });

//     socket.on(
//       "send-message",
//       async ({ msg, sender, receiver, replyId, chatId }) => {
//         // console.log('replyId ',replyId )
//         // console.log('chatId ',chatId )
//         // return;
//         console.log("msg", msg, sender, receiver);
//         // const user = await usersController.get(receiver);
//         const userIndex = activeUsers.findIndex(
//           (element) => element.userId == receiver
//         );
//         console.log("userIndex", userIndex);

//         const status = (await chatId)
//           ? chatsController.update(msg, chatId)
//           : chatsController.save(msg, sender, receiver, replyId);
//         if (status) {
//           await draftsController.deleteDraft(sender, receiver);
//           const messages = await chatsController.get(sender, receiver);
//           const oldMessages = await chatsController.getOldMessages(
//             sender,
//             receiver
//           );
//           const newMessages = await chatsController.getNewMessages(
//             sender,
//             receiver
//           );
//           // io.to(socket.id).emit(`send-message`, {messages,sender,receiver});
//           const getLastOne = await chatsController.getLastOne(receiver, sender);
//           console.log("getLastOnes", getLastOne);
//           // io.to(socket.id).emit(`getOldMessages`, {
//           //   oldMessages,
//           //   sender,
//           //   receiver,
//           // });
//           io.to(socket.id).emit(`getNewMessages`, {
//             newMessages,
//             sender,
//             receiver,
//           });
//           if (userIndex > -1) {
//             console.log(
//               "activeUsers[userIndex].socketId",
//               activeUsers[userIndex].socketId
//             );
//             io.to(activeUsers[userIndex].socketId).emit(
//               "info-user",
//               getLastOne
//             );
//             // io.to(user.socket_id).emit(`send-message`, {messages,sender,receiver});

//             // io.to(activeUsers[userIndex].socketId).emit(`getOldMessages`, {
//             //   oldMessages,
//             //   sender,
//             //   receiver,
//             // });
//             io.to(activeUsers[userIndex].socketId).emit(`getNewMessages`, {
//               newMessages,
//               sender,
//               receiver,
//             });
//             io.to(activeUsers[userIndex].socketId).emit(`notification`);
//           }
//         }
//       }
//     );

//     // socket.on("getOldMessages", async ({ sender, receiver }) => {
//     //   const oldMessages = await chatsController.getOldMessages(
//     //     sender,
//     //     receiver
//     //   );
//     //   io.to(socket.id).emit(`getOldMessages`, {
//     //     oldMessages,
//     //     sender,
//     //     receiver,
//     //   });
//     // });

//     // socket.on("getNewMessages", async ({ sender, receiver }) => {
//     //   const newMessages = await chatsController.getNewMessages(
//     //     sender,
//     //     receiver
//     //   );
//     //   io.to(socket.id).emit(`getNewMessages`, {
//     //     newMessages,
//     //     sender,
//     //     receiver,
//     //   });
//     // });

//     socket.on("uploadVoice", async ({ filePath, sender, receiver }) => {
//       // const userReceiver = await usersController.get(receiver);
//       const messages = await chatsController.get(sender, receiver);

//       io.to(socket.id).emit(`send-message`, { messages, sender, receiver });
//       const getLastOne = await chatsController.getLastOne(receiver, sender);
//       const userIndex = activeUsers.findIndex(
//         (element) => element.userId == receiver
//       );
//       if (userIndex != -1) {
//         console.log(
//           "filePath, sender, receiver",
//           userIndex,
//           activeUsers[userIndex].socketId,
//           sender,
//           receiver
//         );
//         io.to(activeUsers[userIndex].socketId).emit("info-user", getLastOne);
//         io.to(activeUsers[userIndex].socketId).emit(`send-message`, {
//           messages,
//           sender,
//           receiver,
//         });
//         io.to(activeUsers[userIndex].socketId).emit(`notification`);
//       }
//     });

//     socket.on("deleteMsg", async ({ idMsg, pvId, myId }) => {
//       console.log("deleteMsg", idMsg, pvId, myId);
//       const messages = await chatsController.delete(idMsg, pvId, myId);
//       io.to(socket.id).emit(`deleteMsg`, { idMsg, pvId, myId });
//       const userIndex = activeUsers.findIndex(
//         (element) => element.userId == pvId
//       );
//       if (userIndex != -1) {
//         io.to(activeUsers[userIndex].socketId).emit(`deleteMsg`, {
//           idMsg,
//           pvId,
//           myId,
//         });
//       }
//     });
//     // socket.on("uploadImage", async ({ filePath, sender, receiver }) => {
//     //   const userReceiver = await usersController.get(receiver);
//     //   const messages = await chatsController.get(sender, receiver);
//     //   // io.to(socket.id).emit(`send-message`, { messages, sender, receiver });
//     //   const getLastOne = await chatsController.getLastOne(receiver, sender);
//     //   io.to(userReceiver.socket_id).emit("info-user", getLastOne);
//     //   // console.log('messages',messages)
//     //   // io.to(userReceiver.socket_id).emit(`send-message`, {
//     //   //   messages,
//     //   //   sender,
//     //   //   receiver,
//     //   // });
//     //   // io.to(socket.id).to(userReceiver.socket_id).emit(`getNewMessages`, {
//     //   //   filePath,
//     //   //   sender,
//     //   //   receiver,
//     //   // });
//     //   io.to(userReceiver.socket_id).emit(`notification`);

//     //   const newMessages = await chatsController.getNewMessages(
//     //     sender,
//     //     receiver
//     //   );
//     //   io.to(socket.id).to(userReceiver.socket_id).emit(`getNewMessages`, {
//     //     newMessages,
//     //     sender,
//     //     receiver,
//     //   });
//     //   socket.on("getOldMessages", async ({ sender, receiver }) => {
//     //     const oldMessages = await chatsController.getOldMessages(
//     //       sender,
//     //       receiver
//     //     );
//     //     io.to(socket.id).to(userReceiver.socket_id).emit(`getOldMessages`, {
//     //       oldMessages,
//     //       sender,
//     //       receiver,
//     //     });
//     //   });
//     // });

//     socket.on("seen", async ({ sender, receiver }) => {
//       const seen = await chatsController.seen(sender, receiver);
//       const getCountNewMessages = await chatsController.getCountNewMessages(
//         sender,
//         receiver
//       );
//       console.log("getCountNewMessages", getCountNewMessages);
//       const newMessages = await chatsController.getNewMessages(
//         sender,
//         receiver
//       );
//       io.to(socket.id).emit(`info-user${receiver}`, getCountNewMessages);
//       io.to(socket.id).emit(`getNewMessages`, {
//         newMessages,
//         sender,
//         receiver,
//       });
//       const userIndex = activeUsers.findIndex(
//         (element) => element.userId == sender
//       );
//       if (userIndex != -1) {
//         io.to(activeUsers[userIndex].socketId).emit(`getNewMessages`, {
//           newMessages,
//           sender,
//           receiver,
//         });
//       }
//     });
//     socket.on("seenById", async ({ msgId, sender, receiver, msg }) => {
//       console.log("seenById", msgId, sender, receiver, msg);
//       //      const userSender = await usersController.get(sender);
//       //      const userReceiver = await usersController.get(receiver);
//       const seen = await chatsController.seenMsg(msgId);
//       // const messages = await chatsController.get(sender,receiver)
//       // io.to(socket.id).emit(`send-message`, {messages,sender,receiver});
//       // io.to(userReceiver.socket_id).emit(`unread-count${sender}`)
//       // io.to(userSender.socket_id).emit(`readed-messages${receiver}`,messages)
//       //      const oldMessages = await chatsController.getOldMessages(
//       //        sender,
//       //        receiver
//       //      );
//       const getCountNewMessages = await chatsController.getCountNewMessages(
//         sender,
//         receiver
//       );
//       // io.to(socket.id).emit(`send-message`, {messages,sender,receiver});
//       //      const getLastOne = await chatsController.getLastOne(receiver, sender);
//       io.to(socket.id).emit(`info-user${sender}`, getCountNewMessages);

//       // io.to(user.socket_id).emit(`send-message`, {messages,sender,receiver});

//       // io.to(userSender.socket_id).emit(`seenById${msgId}`);

//       //      io.to(socket.id).to(userSender.socket_id).emit(`getOldMessages`, {oldMessages,sender,receiver});
//       //      io.to(socket.id).to(userSender.socket_id).emit(`getNewMessages`, {newMessages,sender,receiver});

//       // io.to(userReceiver.socket_id).to(socket.id).emit(`send-message`, {messages,sender,receiver});

//       const userIndex = activeUsers.findIndex(
//         (element) => element.userId == sender
//       );
//       if (userIndex != -1) {
//         io.to(activeUsers[userIndex].socketId).emit(`seenById${msgId}`, {
//           receiver,
//           sender,
//         });
//       }
//     });

//     // socket.on("draftMsg", async ({ msg, reciver, sender }) => {
//     //   await draftsController.draft(msg, sender, reciver);
//     //   io.to(socket.id).emit(`draftMsg`, { msg, reciver, sender });
//     // });
//     socket.on("editMsg", async ({ msg, msgId, receiver, sender }) => {
//       await draftsController.draft(msg, sender, receiver, "edit", msgId);
//       // console.log('getdraft',msg, msgId, receiver, sender)message, sender, receiver, type="normal" ,chatId=''
//       const getdraft = await draftsController.get({ sender, receiver });

//       console.log("getdraft", getdraft);
//       const chat = await chatsController.getById(msgId);
//       if (chat.sender) {
//         const user = await usersController.getById(chat.sender);
//         console.log("chatchat", chat, user, {
//           msgId,
//           msg: chat.message,
//           username: user.username,
//         });
//         io.to(socket.id).emit(`editMsg`, {
//           draftId: getdraft._id,
//           type: getdraft.type,
//           draftMsg: getdraft.message,
//           msgId,
//           msg,
//           username: user.username,
//         });
//       }
//     });
//     socket.on("replyMsg", async ({ msg, msgId, receiver, sender }) => {
//       await draftsController.draft("", sender, receiver, "reply", msgId);
//       // console.log('getdraft',msg, msgId, receiver, sender)(msg,sender ,receiver ,"edit",msgId);
//       const getdraft = await draftsController.get({ sender, receiver });

//       console.log("getdraft", getdraft);
//       const chat = await chatsController.getById(msgId);
//       if (chat.sender) {
//         const user = await usersController.getById(chat.sender);
//         console.log("chatchat", chat, user, {
//           msgId,
//           msg: chat.message,
//           username: user.username,
//         });
//         const msg = getReplyMsgFromChat(chat);
//         // console.log('msg',msg)
//         // let msg = chat.type == 'voice' ? 'ðŸŽ¤ Voice message': chat.message;
//         io.to(socket.id).emit(`replyMsg`, {
//           draftId: getdraft._id,
//           type: getdraft.type,
//           draftMsg: getdraft.message,
//           msgId,
//           msg,
//           username: user.username,
//         });
//       }
//     });
//     socket.on("getReplyMsg", async ({ sender, receiver }) => {
//       // await draftsController.draft('',sender ,receiver ,msgId);
//       // console.log('getdraft',msg, msgId, receiver, sender)
//       const getdraft = await draftsController.get({ sender, receiver });

//       console.log("getdraft", getdraft);
//       // const chat = await chatsController.getById(getdraft.);
//       if (getdraft && getdraft.type && getdraft.chatId) {
//         const chat = await chatsController.getById(getdraft.chatId);
//         const user = await usersController.getById(sender);
//         console.log("chatchat", chat, user, {
//           msgId: chat._id,
//           msg: chat.message,
//           username: user.username,
//         });
//         io.to(socket.id).emit(`replyMsg`, {
//           draftId: getdraft._id,
//           type: getdraft.type,
//           draftMsg: getdraft.message,
//           msgId: chat._id,
//           msg: chat.message,
//           username: user.username,
//         });
//       }
//     });
//     socket.on("getEditMsg", async ({ sender, receiver }) => {
//       const getdraft = await draftsController.get({ sender, receiver });
//       if (getdraft && getdraft.type && getdraft.chatId) {
//         const chat = await chatsController.getById(getdraft.chatId);
//         const user = await usersController.getById(sender);
//         io.to(socket.id).emit(`editMsg`, {
//           draftId: getdraft._id,
//           type: getdraft.type,
//           draftMsg: getdraft.message,
//           msgId: chat._id,
//           msg: chat.message,
//           username: user.username,
//         });
//       }
//     });
//     socket.on("deleteReplyMsg", async (draftId) => {
//       console.log("draftId", draftId);
//       await draftsController.update(
//         { _id: draftId },
//         { chatId: "", type: "", message: "" }
//       );
//       io.to(socket.id).emit(`deleteReplyMsg`);
//     });
//     socket.on("deleteEditMsg", async (draftId) => {
//       console.log("draftId", draftId);
//       await draftsController.update(
//         { _id: draftId },
//         { chatId: "", type: "", message: "" }
//       );
//       io.to(socket.id).emit(`deleteEditMsg`);
//     });
//     socket.on("istyping", async ({ msg, reciver, sender }) => {
//       console.log("msg,reciver, sender", msg, reciver, sender);
//       draftsController.draft(msg, sender, reciver);
//       const userIndex = activeUsers.findIndex(
//         (element) => element.userId == reciver
//       );
//       if (userIndex != -1) {
//         io.to(activeUsers[userIndex].socketId).emit(`istyping`, {
//           reciver,
//           sender,
//         });
//       }
//       // const user = await usersController.get(reciver);
//     });
//     socket.on("disconnect", () => {
//       // console.log(
//       //   "socket disconnected...",
//       //   socket.id,
//       //   socket.handshake.query.userId
//       // );
//       const userIndex = activeUsers.findIndex(
//         (element) => element.userId == socket.handshake.query.userId
//       );
//       if (userIndex > -1) {
//         activeUsers.splice(userIndex, 1);
//       }
//       console.log("activeUsers dis", activeUsers);
//       usersController.update(socket.handshake.query.userId);
//       io.emit(`offline`, activeUsers);
//       // socket.emit(`offline`, {
//       //   activeUsers,
//       //   socketId: socket.id,
//       //   userId: socket.handshake.query.userId,
//       // });
//       // socket.broadcast.emit('callended');
//     });

//     // Start Video Call
//     //   socket.on("calluser", async({ userToCall, signalData, from }) => {
//     //     const userCall = await usersController.get(userToCall);
//     //     io.to(userCall.socket_id).emit("calluser", { signal: signalData, from });
//     //   });
//     //   socket.on('answercall', async(data) => {
//     //     // console.log('signal',data.to)
//     //     const userCall = await usersController.get(data.to);
//     //     // console.log('signal',userCall.socket_id)
//     //     io.to(userCall.socket_id).emit('callaccepted', data.signal);
//     // });
//     // End Video Call

//     // groups
//     // socket.on("info-group", async ({ item, me }) => {
//     //   // const getLastOne = await chatsController.getLastOne( me,item._id)
//     //   // io.to(socket.id).emit('info-group',getLastOne)
//     // });

//     // socket.on("send-group", async ({ msg,sender, receiver }) => {
//     //   // const getLastOne = await chatsController.getLastOne( me,item._id)
//     //   // io.to(socket.id).emit('info-group',getLastOne)
//     //   io.breadcast.to(receiver).emit('info-group',getLastOne)
//     // });
//   });
// };
