const db = require("../configs/db/connections/mongoose");
const mongoose = require("mongoose");
const Draft = require("../configs/db/models/mongoose/draft");

exports.draft = async (message, sender, receiver, type ,chatId) => {
  const draft = await Draft.find({
    sender,
    receiver,
  });
  console.log("draft", draft);
  if (draft.length == 0) {
    const draft = new Draft({
      sender,
      receiver,
      message,
      type,
      chatId
    });
    await draft.save();
  } else {
    await Draft.updateOne({ sender, receiver }, { message,chatId ,type});
  }
  const draft2 = await Draft.find({
    sender,
    receiver,
  });
  console.log("draft2", draft2);
};

// DELETE endpoint
exports.deleteDraft = async (sender, receiver) => {
  await Draft.deleteOne({ sender, receiver });
};

exports.getDraft = async (req, res) => {
  const { myId: sender, pvId: receiver } = req.query;
  const draft = await Draft.find({
    sender,
    receiver,
  }).select("message");
  res.status(200).json(draft);
};

exports.get = async (filter) => {
  console.log(filter)
  try {
    const draft = await Draft.findOne(filter);
    console.log(draft)
    return draft;
  } catch (error) {
    console.error('Error retrieving data:', error);
    throw error; // Re-throw the error to indicate failure
  }
};
exports.update = async (filter,data) => {
  await Draft.updateOne(filter, { $set: data });
};


