const mongoose = require("mongoose");
const Schema = mongoose.Schema;

const channelsSchema = Schema(
  {
    name: { type: String, required: true },
    description: { type: String },
    creator: { type: Schema.Types.ObjectId, ref: "User", required: true },
    members: [{ type: Schema.Types.ObjectId, ref: "User" }],
    avatar: { type: String },
    messages: [
      {
        sender: { type: Schema.Types.ObjectId, ref: "User", required: true },
        username:{type:String},
        content: { type: String, required: true },
        timestamp: { type: Date, default: Date.now },
        edited: {
          type: Boolean,
          default: false,
          required: true,
        },
        type: {
          type: String,
          enum: ["file", "msg", "img", "voice"],
          required: true,
        },
        file: {
          name: { type: String },
          type: { type: String },
          size: { type: String },
        },
        seen: {
          type: String,
          enum: ["0", "1", "2"],
          default: "0",
        },
      },
    ],
  },
  { timestamps: true }
);

module.exports = mongoose.model("Channel", channelsSchema);
